import 'package:flutter/material.dart';
import 'package:flutter/widgets.dart';
import 'package:user/bloc/user_bloc.dart';
import 'package:user/model/user.dart';
import 'package:user/model/user_response.dart';

class UserWidget extends StatefulWidget {
  @override
  State<StatefulWidget> createState() {
    return _UserWidgetState();
  }
}

class _UserWidgetState extends State<UserWidget> {
  @override
  void initState() {
    print('UserWidget - constructor...');
    super.initState();
    print('bloc calls getUser()');
    bloc.getUser();
  }

  @override
  Widget build(BuildContext context) {
    print(
        'user_widget.dart - Built StreamBuilder that sends data from state back to UI');
    return StreamBuilder<UserResponse>(
      stream: bloc.subject.stream, // subject is BehaviorSubject
      builder: (context, AsyncSnapshot<UserResponse> snapshot) {
        // AsyncSnapshot, async.dart
        print('user_widget.dart - received SNAPSHOT');

        if (snapshot.hasData) {
          print('user_widget.dart - _buildErrorWidget');
          if (snapshot.data.error != null && snapshot.data.error.length > 0) {
            return _buildErrorWidget(snapshot.data.error);
          }
          print(
              ' user_widget.dart - AsyncSnapshot is fine...so lets build standard user Widget with snapshot data');
          return _buildUserWidget(snapshot.data);
        } else if (snapshot.hasError) {
          return _buildErrorWidget(snapshot.error);
        } else {
          print('user_widget.dart - _buildLoadingWidget');
          return _buildLoadingWidget();
        }
      },
    );
  }

  Widget _buildLoadingWidget() {
    return Center(
        child: Column(
      mainAxisAlignment: MainAxisAlignment.center,
      children: [
        Text("Loading data from API...",
            style: Theme.of(context).textTheme.subtitle2),
        Padding(
          padding: EdgeInsets.only(top: 5),
        ),
        CircularProgressIndicator(
          valueColor: new AlwaysStoppedAnimation<Color>(Colors.white),
        )
      ],
    ));
  }

  Widget _buildErrorWidget(String error) {
    return Center(
        child: Column(
      mainAxisAlignment: MainAxisAlignment.center,
      children: [
        Text("Error occured: $error",
            style: Theme.of(context).textTheme.subtitle2),
      ],
    ));
  }

  Widget _buildUserWidget(UserResponse data) {
    print('UI _buildUserWidget');
    User user = data.results[0];
    return Center(
        child: Column(
      mainAxisAlignment: MainAxisAlignment.center,
      children: [
        CircleAvatar(
          radius: 70,
          backgroundImage: NetworkImage(user.picture.large),
        ),
        Text(
          "${_capitalizeFirstLetter(user.name.first)} ${_capitalizeFirstLetter(user.name.last)}",
          style: Theme.of(context).textTheme.headline6,
        ),
        Text(user.email, style: Theme.of(context).textTheme.subtitle2),
        Padding(
          padding: EdgeInsets.only(top: 5),
        ),
        Text(
            user.location.street.name +
                ", " +
                user.location.street.number.toString(),
            style: Theme.of(context).textTheme.bodyText2),
        Padding(
          padding: EdgeInsets.only(top: 5),
        ),
        Text(user.location.city, style: Theme.of(context).textTheme.bodyText2),
        Padding(
          padding: EdgeInsets.only(top: 5),
        ),
        Text(user.location.state, style: Theme.of(context).textTheme.bodyText2),
      ],
    ));
  }

  _capitalizeFirstLetter(String text) {
    return text.substring(0, 1).toUpperCase() + text.substring(0, text.length);
  }
}
