import 'package:user/model/user_response.dart';
import 'package:user/repository/user_repository.dart';
import 'package:rxdart/rxdart.dart';

class UserBloc {
  final UserRepository _repository = UserRepository();

  UserBloc() {
    print('UserBlock constructor');
  }
  final BehaviorSubject<UserResponse> _subject =
      BehaviorSubject<UserResponse>();

  getUser() async {
    print('user_bloc.dart - getUser');
    UserResponse response = await _repository.getUser();
    print('user_bloc.dart - add response to _subject.sink');
    _subject.sink.add(response);
  }

  dispose() {
    _subject.close();
  }

  BehaviorSubject<UserResponse> get subject => _subject;
}

final bloc = UserBloc();
