//
//  DoubleLinkedList.hpp
//  DoublyLinkedList
//
//  Created by  Ricky Tsao on 12/23/16.
//  Copyright © 2016 Epam. All rights reserved.
//

#ifndef DoubleLinkedList_hpp
#define DoubleLinkedList_hpp


#include <stdio.h>
#include <iostream>


enum Color {
    
    GREEN=1,
    ORANGE=2,
    LIGHT_BLUE=3,
    RED=4,
    PURPLE=5
};


struct Node {
    
    char * locationName;
    
    struct Node * previous;
    struct Node * next;
    
    //constructor
    Node(char * newLocationName, struct Node * newNext, struct Node * newPrevious) {
        
        this->locationName = newLocationName;
        
        this->next = newNext;
        this->previous = newPrevious;
    }
    
    void log() {

        std::cout << "[" << this->locationName << "]";
    }
    
    
}; // declares the struct type


//a list if a metro line

class DoubleLinkedList {
    
    private:
    
        struct Node * first;
        struct Node * last;
        Color metroLineColor;
    
        struct Node * find (char * nameOfStation);
    
    public:
        
        DoubleLinkedList(Color lineColor);
        ~DoubleLinkedList();
    
        void insertStart(char * nameOfStation);
        void deletStart();
        
        void insertLast(char * nameOfStation);
        void deleteLast();
        
        void insertAfter(char *  nameOfTargetStation, char * nameOfStationToInsert);
    
        void displayForward();
        void displayBackward();
};


#endif /* DoubleLinkedList_hpp */
