//
//  DoubleLinkedList.cpp
//  DoublyLinkedList
//
//  Created by  Ricky Tsao on 12/23/16.
//  Copyright © 2016 Epam. All rights reserved.
//

#include "DoubleLinkedList.hpp"


DoubleLinkedList::DoubleLinkedList(Color lineColor) {
    
    std::cout << "Constructor" << std::endl;
    
    this->metroLineColor    = lineColor;
    this->first             = NULL;
    this->last              = NULL;
}


DoubleLinkedList::~DoubleLinkedList() {
    
    std::cout << "\n\n========= Deconstructing Metro Line ==========" << std::endl;
    for (struct Node * temp = this->first; temp != NULL;) {
        
        struct Node * toDelete = temp;
        
        temp = temp->next; //go forward once step
        
        std::cout << "Deleting station " << toDelete->locationName << std::endl;
        toDelete->previous = NULL;
        toDelete->next = NULL;
        toDelete->locationName = NULL;
        
        delete toDelete;
    }
    
    this->first             = NULL;
    this->last              = NULL;
}


void DoubleLinkedList::insertStart(char * nameOfStation) {
    
    if(this->first == NULL && this->last == NULL) {
        
        std::cout << "List is empty" << std:: endl;
        this->first = new (struct Node)(nameOfStation, NULL, NULL);
        this->last = this->first;
        
    } else {
        
        std::cout   << "List has items, let's insert at the very first station:"
                    << this->first->locationName
                    << std:: endl;
        
        struct Node * temp = new (struct Node)(nameOfStation, this->first, NULL);
        
        this->first->previous = temp;
        this->first = temp;
    }
    
    std::cout << "done" << std::endl;
}

void DoubleLinkedList::insertLast(char * nameOfStation) {
    

    if(this->first == NULL && this->last == NULL) {
        
        std::cout << "List is empty" << std:: endl;
        this->first = new (struct Node)(nameOfStation, NULL, NULL);
        this->last = this->first;
        
    } else {
        
        std::cout << "List is empty" << std:: endl;
        
        // <--[]--NULL
        
        struct Node * temp = new (struct Node)(nameOfStation, NULL, this->last);
        this->last->next = temp;
        this->last = temp;
        
    }
}


struct Node * DoubleLinkedList::find (char * nameOfStation) {
    
    std::cout << " looking for station: " << nameOfStation << std::endl;
    
    for ( struct Node * temp = this->first; temp != NULL; temp = temp->next) {
        
        if(strcasecmp(temp->locationName, nameOfStation)==0) {
            std::cout << " found the station: " << nameOfStation << std::endl;
            return temp;
        }
    }
    
    std::cout << "station not found!" << std::endl;
    return NULL;
}

void DoubleLinkedList::insertAfter(char *  nameOfTargetStation, char * nameOfStationToInsert) {
    
    struct Node * found = this->find(nameOfTargetStation);
    
    struct Node * temp = new (struct Node)(nameOfStationToInsert, NULL, NULL);
    
    if(found) {
        temp->next              = found->next;
        temp->previous          = found;
        
        found->next->previous   = temp;
        found->next             = temp;
        
    } else {
        std::cout << "can't insert. target station not found" << nameOfTargetStation << std::endl;
    }
}


void DoubleLinkedList::displayForward() {
    
    std::cout << "\n\n------- display all stations forward ---------" << std::endl;
    
    if (this->first == NULL) {
        std::cout << "EMPTY: No station(s)" << std::endl;
        return;
    }
    
    std::cout << "||";
    for (struct Node * temp = this->first; temp != NULL; temp = temp->next) {
        temp->log();
    }
    std::cout << "||";
}

void DoubleLinkedList::displayBackward() {
    
    std::cout << "\n\n------- display all stations backwards ---------" << std::endl;
    std::cout << "||";
    for (struct Node * temp = this->last; temp != NULL; temp = temp->previous) {
        temp->log();
    }
    std::cout << "||";
}


void DoubleLinkedList::deletStart() {

    if(this->first==NULL) {
        std::cout << "\n\nCan't deleteStart, list is empty" << std::endl;
        return;
    }
    
    struct Node * temp = this->first;
    this->first = this->first->next;
    
    //if we're on the last item, let's assign both properties to NULL
    if(this->first==NULL) this->last = NULL;
    
    temp->previous = NULL;
    temp->next = NULL;
    temp->locationName = NULL;
    
    delete temp;
}

void DoubleLinkedList::deleteLast() {
    
    if(this->last==NULL) {
        std::cout << "\n\nCan't deleteStart, list is empty" << std::endl;
        return;
    }
    
    struct Node * temp = this->last;
    this->last = this->last->previous;
    
    if(this->last==NULL) {
        this->first = NULL;
    } else {
        this->last->next = NULL; //repoint the last one
    }
    
    //delete the station
    temp->previous          = NULL;
    temp->next              = NULL;
    temp->locationName      = NULL;
    
    delete temp;

}


