//
//  BNRCoreDataCoordinator.m
//  AsyncFetchRequestEx
//
//  Created by  Ricky Tsao on 8/31/16.
//  Copyright © 2016 Epam. All rights reserved.
//

#import "BNRCoreDataCoordinator.h"
#import "Entity.h"

static NSUInteger const BNRCoreDataBatchingInitialSize = 8000;

@implementation BNRCoreDataCoordinator

@synthesize managedObjectContext        = _managedObjectContext;
@synthesize persistentStoreCoordinator  = _persistentStoreCoordinator;


#pragma mark - UPDATE

//- (void)manuallyUpdateAllEntitiesAcknowledged:(BOOL)acknowledged
//                               withCompletion:(void (^)(float))completion {
//    
//    NSLog(@"%s", __FUNCTION__);
//    
//    __weak typeof (self) weakSelf = self;
//    [_managedObjectContext performBlock:^{
//        
//        __strong typeof (weakSelf) strongSelf = weakSelf;
//        
//       
//        NSArray *items = [strongSelf allEntitiesAcknowledged:!acknowledged];
//        
//        [items makeObjectsPerformSelector:@selector(setAcknowledged:) withObject:@(acknowledged)];
//    
//        [strongSelf saveContext];
//        
//        
//        dispatch_async(dispatch_get_main_queue(), ^{
//            completion(0.0f);
//        });
//    }];
//}


#pragma mark - Initial Insertion

//get number of all entities currently in Core Data

//- (NSUInteger)numberOfAllEntities {
//    
//    NSError *fetchError = nil;
//    
//    //fetch request for all Entity
//    NSLog(@"%s - Fetch Request for all Entity objects", __FUNCTION__);
//    NSFetchRequest *request = [[NSFetchRequest alloc] initWithEntityName:NSStringFromClass(Entity.class)];
//    
//    //IF IT DID process (executeFetchRequest:error), what would the count be?
//    NSUInteger count = [_managedObjectContext countForFetchRequest:request error:&fetchError];
//    NSAssert(!fetchError, @"Fetch failed");
//    return count;
//}

- (void)insertInitialDataSetWithCompletion:(void (^)(BOOL))completion {
    __weak typeof(self) weakSelf = self;
    
    [self.managedObjectContext performBlock:^{
        
        NSLog(@"--- put this block of insertion code in the MOC queue");
        __strong typeof (weakSelf) strongSelf   = weakSelf;
        
        //NSUInteger count                        = [strongSelf numberOfAllEntities];
        NSUInteger count = 0;
        
        NSLog(@"%lu", (unsigned long)count);
        
        for (NSUInteger index = count; index < BNRCoreDataBatchingInitialSize; index++) {
            
            // return an object for us to initialize, once we set the properties, we add it
            // by saving the MOC context in saveContext method
            Entity * newEntity = [NSEntityDescription insertNewObjectForEntityForName:NSStringFromClass(Entity.class)
                                                              inManagedObjectContext:_managedObjectContext];
            
            newEntity.title = [NSString stringWithFormat:@"%ld: Entity", (long)index + 1];
            newEntity.acknowledged = @(NO);
            NSLog(@"Inserted %ld of %ld", (long)index + 1, (long)BNRCoreDataBatchingInitialSize);
        }
        
        
        BOOL success = [strongSelf saveContext];
        
        //success is done. we gotta use the main queue to update the UI
        dispatch_async(dispatch_get_main_queue(), ^{
            completion(success);
        });
    }];
}


#pragma mark - Saving

//Moc saves its changes
- (BOOL)saveContext {
    NSLog(@"MOC SAVING CONTEXT ------ %s ---------", __FUNCTION__);
    
    BOOL success = YES;
    NSError *saveError = nil;
    if ([_managedObjectContext hasChanges] && ![_managedObjectContext save:&saveError]) {
        success = NO;
        NSLog(@"Saving failed with error: %@", saveError);
    }
    return success;
}


#pragma mark - Accessors

- (NSManagedObjectContext *)managedObjectContext {
    
    if (!_managedObjectContext) {
        
        _managedObjectContext               = [[NSManagedObjectContext alloc] initWithConcurrencyType:NSPrivateQueueConcurrencyType];
        _managedObjectContext.mergePolicy   = [[NSMergePolicy alloc] initWithMergeType:NSMergeByPropertyStoreTrumpMergePolicyType];
        _managedObjectContext.persistentStoreCoordinator = self.persistentStoreCoordinator;
        NSLog(@"%s - MOC created ", __FUNCTION__);
    }
    return _managedObjectContext;
}

- (NSPersistentStoreCoordinator *)persistentStoreCoordinator {
    if (!_persistentStoreCoordinator) {
        NSLog(@"%s - Creating PSC --", __FUNCTION__);
        
        NSURL *modelURL             = [[NSBundle mainBundle] URLForResource:@"CoreDataBatching" withExtension:@"momd"];
        NSLog(@"%s - url of CoreDataBatching.momd file: %@ --", __FUNCTION__, [modelURL absoluteString]);
        
        NSManagedObjectModel *model = [[NSManagedObjectModel alloc] initWithContentsOfURL:modelURL];
        
        _persistentStoreCoordinator = [[NSPersistentStoreCoordinator alloc] initWithManagedObjectModel:model];
        
        NSURL *documentsDir         = [[[NSFileManager defaultManager] URLsForDirectory:NSDocumentDirectory inDomains:NSUserDomainMask] lastObject];
        NSURL *storeURL             = [documentsDir URLByAppendingPathComponent:@"store.sqlite"];
        NSLog(@"%@", [storeURL absoluteString]);
        
        NSError *addingStoreError   = nil;
        NSDictionary *storeOptions  = @{NSMigratePersistentStoresAutomaticallyOption: @(YES),
                                        NSInferMappingModelAutomaticallyOption: @(YES)};
        
        NSPersistentStore *store = [_persistentStoreCoordinator addPersistentStoreWithType:NSSQLiteStoreType
                                                                             configuration:nil
                                                                                       URL:storeURL
                                                                                   options:storeOptions
                                                                                     error:&addingStoreError];
        if (!store || addingStoreError) {
            NSLog(@"Big problems man: %@", addingStoreError);
        }
        
        NSLog(@"%s - Created PSC  --", __FUNCTION__);
    }
    return _persistentStoreCoordinator;
}



@end
