//
//  MovieLister.m
//  LooseCoupling1
//
//  Created by  Ricky Tsao on 8/4/16.
//  Copyright © 2016 Epam. All rights reserved.
//

#import "MovieLister.h"
#import "Movie.h"
#import "TextFileMovieFinder.h"

@interface MovieLister ()
{
    
}

//declare our movie finder object
//@property (nonatomic, strong) TextFileMovieFinder * finder;

@end


@implementation MovieLister


- (id)init {
    self = [super init];
    
    if (self) {
        _finder = [[TextFileMovieFinder alloc] initWithTextFileName:@"movies.txt"];
    }
    return self;
}


- (NSArray *)moviesDirectedByDirector:(NSString *)director {
    
    //1)
    //What is Finder and where it came from?
    
    //We need to have Finder inside the method to get the list of the movies.
    //How can we get the Finder inside the method?
    
    //The simplest and wrong solution is to create the required object inside the method.
    
    //In this case the method (moviesDirectedByDirector) fully depends on the exact implementation
    //of the exact class TestFileMovieFinder.
    
//    TextFileMovieFinder * finder = [[TextFileMovieFinder alloc] initWithTextFileName:@"movies.txt"];
//    NSArray *allMovies = [finder findAllMovies];
//    NSMutableArray *result = [NSMutableArray array];
//    
//    for (Movie * movie in allMovies) {
//        if ([movie.director isEqualToString:director]) {
//            [result addObject:movie];
//        }
//    }
//    return result;
    
    //2) using a protocol interface
    //finder is an object that conforms to protocol MovieFinder, and it must
    //implement method findAllMovies
    
    //disadvantages: 
//    NSArray * allMovies = [self.finder findAllMovies];
//    
//    NSMutableArray *result = [NSMutableArray array];
//    
//    for (Movie * movie in allMovies) {
//        if ([movie.director isEqualToString:director]) {
//            [result addObject:movie];
//        }
//    }
//    return result;
    
    NSArray * allMovies     = [self.finder findAllMovies];
    NSMutableArray *result  = [NSMutableArray array];

    for (Movie * movie in allMovies) {
        if ([movie.director isEqualToString:director]) {
            [result addObject:movie];
        }
    }
    return result;
    
}

#pragma mark InjectDependent delegate method
- (void)injectDependency:(id<Injectable>)dependency {
    self.finder = dependency;
}


@end
